<?php

class bt_bb_timetable extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'title'					=> '',
			'location'				=> '',
			'content'				=> ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}


		$output_inner = '';
		$items_arr = preg_split( '/$\R?^/m', $content );
		if ( count( $items_arr ) > 0 ) {
			foreach ( $items_arr as $item ) { 
				$item = preg_replace('~[\r\n]+~', '', $item);
				if ( $item == '' ) break;
				$item_arr = explode( ';', $item );
				if ( count( $item_arr ) < 2 ) break;
				$bt_extra_row_class = '';
				$bt_extra_data = '';
				if ( isset( $item_arr[2] ) ) {
					$bt_extra_data = ' data-day="' . esc_attr( $item_arr[2] ) . '"';
					if ( strtolower ( date('D') ) ==  strtolower ( $item_arr[2] )) $bt_extra_row_class = ' btToday';	
				}
				$output_inner .= '<div class="' . esc_attr( $this->shortcode . '_inner_row' ) . $bt_extra_row_class . '"' . $bt_extra_data . '>';
					$output_inner .= '<div class="' . esc_attr( $this->shortcode . '_day' ) . '">';
						$output_inner .= '<span>' . $item_arr[0] . '</span>';
						if ( isset ($item_arr[3]) && $item_arr[3] != '' )  $output_inner .= '<span class="' . esc_attr( $this->shortcode . '_inner_desc' ) . '">' . $item_arr[3] . '</span>';
					$output_inner .= '</div>';
					$output_inner .= '<div class="' . esc_attr( $this->shortcode . '_time' ) . '">';
						$output_inner .= '<span>' . $item_arr[1] . '</span>';
						if ( isset ( $item_arr[4] ) && $item_arr[4] != '' ) $output_inner .= '<span class="' . esc_attr( $this->shortcode . '_inner_location' ) . '">' . $item_arr[4] . '</span>';
					$output_inner .= '</div>';
				$output_inner .= '</div>';				
			} 
		}
		$output = '<div class="' . esc_attr( $this->shortcode . '_title_flex' ) . '">';
			if ( $title != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_title' ) . '">' . $title . '</div>';
			if ( $location != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_location' ) . '">' . $location . '</div>';
		$output .= '</div>';
		$output .= '<div class="' . esc_attr( $this->shortcode . '_content' ) . '">';
			$output .= $output_inner;
		$output .= '</div>';

		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>' . $output . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;
	}	

	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Timetable', 'oxigeno' ), 'description' => esc_html__( 'Timetable list', 'oxigeno' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'oxigeno' ) ),
				array( 'param_name' => 'location', 'type' => 'textfield', 'heading' => esc_html__( 'Location', 'oxigeno' ), 'preview' => true ),
				array( 'param_name' => 'content', 'type' => 'textarea', 'heading' => esc_html__( 'Timetable', 'oxigeno' ), 'description' => esc_html__( 'day;time;day abbreviation (e.x. MON for monday);description;location', 'oxigeno' )
				)
			))
		);
	}
}