<?php

class bt_bb_table extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'content'	=> '',
			'marked'	=> ''
		) ), $atts, $this->shortcode ) );


		$content = html_entity_decode( $content, ENT_QUOTES, 'UTF-8' );

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$output_inner = '';
		
		$items_arr = preg_split( '/$\R?^/m', $content );
		
		$marked_arr = array_map('trim', explode(',', $marked));
		
		foreach ( $items_arr as $item ) {
			$item = preg_replace('~[\r\n]+~', '', $item);
			$item_arr = explode( ';', $item );	
			$extra_class = "";
			in_array($item_arr[0], $marked_arr) ? $extra_class = " btMarkedRow" : "";
			$output_inner .= '<tr class="' . esc_attr( $this->shortcode . '_row' ) . $extra_class . '">';
				foreach ($item_arr as $item_value) {
					$item_value_arr = explode( '#href#', $item_value );
					$output_inner .= '<td class="' . esc_attr( $this->shortcode . '_value' ) . '">';
						if ( count( $item_value_arr ) > 1 ) {
							$output_inner .= '<span><a href="' . bt_bb_get_permalink_by_slug( $item_value_arr[1] ) . '">' . $item_value_arr[0] . '</span>';
						} else {
							$output_inner .= '<span>' . $item_value_arr[0] . '</span>';
						}
					$output_inner .= '</td>';
				}				
			$output_inner .= '</tr>';
		}

		$output = '<table' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>' . $output_inner . '</table>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;
	}

	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Table', 'oxigeno' ), 'description' => esc_html__( 'Table with list of results', 'oxigeno' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'content', 'type' => 'textarea', 'heading' => esc_html__( 'Content', 'oxigeno' ), 'description' => esc_html__( 'Format: col_01;col_02;col_03 separated by new line. Add #href#URL to add link. F.e. col_01#href#team-details', 'oxigeno' )
				),
				array( 'param_name' => 'marked', 'type' => 'textfield', 'heading' => esc_html__( 'Marked row', 'oxigeno' ), 'description' => esc_html__( 'Marked rows first columns separated by ,', 'oxigeno' ), 'preview' => true ),
			))
		);
	}
}