<?php

class bt_bb_game_result extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'supertitle'     		=> '',
			'image_1'        		=> '',
			'title_1'        		=> '',
			'subtitle_1'     		=> '',			
			'title_2'        		=> '',
			'subtitle_2'     		=> '',
			'image_2'        		=> '',
			'url'					=> '',
			'button_text'     		=> '',
			'target'       			=> ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		if ( $url != '' && $url != '#' && substr( $url, 0, 4 ) != 'http' && substr( $url, 0, 5 ) != 'https' && substr( $url, 0, 6 ) != 'mailto' ) {
			$link = bt_bb_get_permalink_by_slug( $url );
		} else {
			$link = $url;
		}


		if ( $image_1 != '' && is_numeric( $image_1 ) ) {
			$post_image_1 = get_post( $image_1 );
			$alt_1 = isset($post_image_1) ? get_post_meta($post_image_1->ID, '_wp_attachment_image_alt', true) : '';
			if ( $post_image_1 == '' ) return;

			$image_1 = wp_get_attachment_image_src( $image_1, "full");
			$image_1 = $image_1[0];
			/*if ( $title_1 == '' ) {
				$alt = $post_image->post_excerpt;
			} else {
				$alt = $title_1;
			}*/
			if ( $alt_1 == '' ) {
				$alt_1 = $subtitle_1;
			}
		}

		if ( $image_2 != '' && is_numeric( $image_2 ) ) {
			$post_image_2 = get_post( $image_2 );
			$alt_2 = isset($post_image_2) ? get_post_meta($post_image_2->ID, '_wp_attachment_image_alt', true) : '';
			if ( $post_image_2 == '' ) return;
		
			$image_2 = wp_get_attachment_image_src( $image_2, "full");
			$image_2 = $image_2[0];

			if ( $alt_2 == '' ) {
				$alt_2 = $subtitle_2;
			}
		}

		$output = '<div class="' . esc_attr( $this->shortcode . '_supertitle' ) . '">' . $supertitle . '</div> ';
		$output .= '<div class="' . esc_attr( $this->shortcode . '_wrap' ) . '">';

			
			$output .= '<div class="' . esc_attr( $this->shortcode . '_team' ) . ' ' . esc_attr( $this->shortcode . '_team_left' ) . '">';
				if ( $image_1 != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_crest' ) . '">' . '<img src="' . esc_url_raw( $image_1 ) . '" alt="' . esc_attr( $alt_1 ) . '">' . '</div>';
				$output .= '<div class="' . esc_attr( $this->shortcode . '_data' ) . '">';
					$output .= '<div class="' . esc_attr( $this->shortcode . '_value' ) . '">' . do_shortcode( "[bt_bb_counter size='large' number='" . $title_1 . "' ignore_fe_editor='true']" ) . '</div>';
					$output .= '<div class="' . esc_attr( $this->shortcode . '_title' ) . '">' . $subtitle_1 . '</div>';
				$output .= '</div>';				
			$output .= '</div>';			
			$output .= '<div class="' . esc_attr( $this->shortcode . '_team' ) . ' ' . esc_attr( $this->shortcode . '_team_right' ) . '">';				
				$output .= '<div class="' . esc_attr( $this->shortcode . '_data' ) . '">';
					$output .= '<div class="' . esc_attr( $this->shortcode . '_value' ) . '">' . do_shortcode( "[bt_bb_counter size='large' number='" . $title_2 . "' ignore_fe_editor='true']" ) . '</div>';
					$output .= '<div class="' . esc_attr( $this->shortcode . '_title' ) . '">' . $subtitle_2 . '</div>';
				$output .= '</div>';
				if ( $image_2 != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_crest' ) . '">' . '<img src="' . esc_url_raw( $image_2 ) . '" alt="' . esc_attr( $alt_2 ) . '">' . '</div>';
			$output .= '</div>';
		$output .= '</div>';		
		if ( $url != '' ) {
			if ( $button_text == '' ) $button_text = 'MORE';
			$output .= '<div class="' . esc_attr( $this->shortcode . '_button' ) . '">';
				$output .= do_shortcode( "[bt_bb_button size='small' url='" . $url . "' text='" . $button_text . "' target='" . $target . "' style='filled' color_scheme='dark-accent-skin' ignore_fe_editor='true']" );
			$output .= '</div>';	
		}

		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>' . $output . '</div>';

		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;
	}	

	function map_shortcode() {
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Game result', 'oxigeno' ), 'description' => esc_html__( 'Game result with score', 'oxigeno' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'supertitle', 'type' => 'textfield', 'heading' => esc_html__( 'Date & place', 'oxigeno' ), 'preview' => true ),
				array( 'param_name' => 'image_1', 'type' => 'attach_image', 'heading' => esc_html__( 'Home team crest', 'oxigeno' ) ),	
				array( 'param_name' => 'title_1', 'type' => 'textfield', 'heading' => esc_html__( 'Home team points', 'oxigeno' ) ),
				array( 'param_name' => 'subtitle_1', 'type' => 'textfield', 'heading' => esc_html__( 'Home team name', 'oxigeno' ), 'preview' => true ),				
				array( 'param_name' => 'title_2', 'type' => 'textfield', 'heading' => esc_html__( 'Away team points', 'oxigeno' ) ),
				array( 'param_name' => 'subtitle_2', 'type' => 'textfield', 'heading' => esc_html__( 'Away team name', 'oxigeno' ), 'preview' => true ),
				array( 'param_name' => 'image_2', 'type' => 'attach_image', 'heading' => esc_html__( 'Away team crest', 'oxigeno' ) ),	
				array( 'param_name' => 'button_text', 'type' => 'textfield', 'heading' => esc_html__( 'Button Text', 'oxigeno' ) ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'oxigeno' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'oxigeno' ), 
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'oxigeno' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'oxigeno' ) => '_blank',
					)
				)
			)
		) );
	} 
}